/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BananaTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BananaTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)16).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.baseHeight), (App)Codec.intRange((int)0, (int)12).fieldOf("height_rand_a").forGetter(trunkPlacer -> trunkPlacer.heightRandA), (App)BlockStateProvider.CODEC.fieldOf("top_log").forGetter(trunkPlacer -> trunkPlacer.topLog)).apply((Applicative)instance, BananaTrunkPlacer::new));
    private final BlockStateProvider topLog;

    public BananaTrunkPlacer(int baseHeight, int heightRandA, BlockStateProvider topLog) {
        super(baseHeight, heightRandA, 0);
        this.topLog = topLog;
    }

    protected TrunkPlacerType<?> type() {
        return FOTTrunkPlacerTypes.BANANA_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BananaTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        for (int i = 0; i < freeTreeHeight; ++i) {
            this.placeLog(level, blockSetter, random, pos.above(i), config, Function.identity(), i, i == freeTreeHeight - 1);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(freeTreeHeight), 0, false));
    }

    private void placeLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, Function<BlockState, BlockState> propertySetter, int height, boolean isTop) {
        if (this.validTreePos(level, pos)) {
            BlockStateProvider log = isTop ? this.topLog : config.trunkProvider;
            BlockState blockState = propertySetter.apply(log.getState(random, pos));
            blockSetter.accept(pos, blockState);
        }
    }
}

